﻿using System.Threading.Tasks;

namespace VA.PPMS.IWS.Functions.Configuration.Interface
{
    public interface IIwsConfiguration
    {
        Task<string> GetBlobNameAsync();
        
        Task<string> GetResponseQueueNameAsync();
        
        Task<string> GetConnectionAsync();

        Task<string> GetOrgClientIdAsync();

        Task<string> GetOrgClientSecretAsync();

        Task<string> GetOrgBaseAsync();

        Task<UrlPacket> GetCcnInitialDataRequestUrlAsync();

        Task<string> GetResponseDocumentPathPatternAsync();

        Task<string> GetResponseDocumentReferenceUrlAsync();

        Task<string> GetPpmsXrmServicesUriAsync();

        Task<string> GetPpmsApiUriAsync();

        Task<string> GetPpmsResponseNotificationUriAsync();

        Task<string> GetPpmsResponsePostUriAsync();

        Task<string> GetCcnDocRefQueueNameAsync();

        Task<SchemaProfile> GetSchemaProfileAsync(SchemaOptions.SchemaProfiles profile);

        Task<string> GetPpmsDasIdentifierAsync();

        Task<string> GetNpiStatusTableNameAsync();

        Task<string> GetActivityHistoryTableNameAsync();

        Task<string> GetProviderPayloadQueueAsync();

        Task<string> GetNppesTargetUri();

        Task<string> GeTargetName(string target);
    }
}